
public class LoadSaveDataEx
{
	private boolean SuccessOrError;
	private String ErrorMessage;
	private String IOProgramString;
	private double ZoomFactor;

	private final String FileStringSeparator = "\01";
	private final int FileStringVersion = 1;

	public LoadSaveDataEx(boolean SuccessOrError, String ErrorMessage, String IOProgramString, double ZoomFactor)
	{
		SetSuccessOrError(SuccessOrError);
		SetErrorMessage(ErrorMessage);
		SetIOProgramString(IOProgramString);
		SetZoomFactor(ZoomFactor);
	}

	public LoadSaveDataEx(String FileString)
	{
		StateFromFileString(FileString); // sets a useful ErrorMessage and SuccessOrError in case of an error
	}

	public String GetErrorMessage()
	{
		return ErrorMessage;
	}

	public String GetIOProgramString()
	{
		return IOProgramString;
	}

	public boolean GetSuccessOrError()
	{
		return SuccessOrError;
	}

	public double GetZoomFactor()
	{
		return ZoomFactor;
	}

	public void SetErrorMessage(String ErrorMessageNew)
	{
		if (ErrorMessageNew == null)
			ErrorMessage = "[unknown error]";
		else
			ErrorMessage = ErrorMessageNew;
	}

	public void SetIOProgramString(String IOProgramStringNew)
	{
		if (IOProgramStringNew == null)
			IOProgramString = "";
		else
			IOProgramString = IOProgramStringNew;
	}

	public void SetSuccessOrError(boolean SuccessOrErrorNew)
	{
		SuccessOrError = SuccessOrErrorNew;
	}

	public void SetZoomFactor(double ZoomFactorNew)
	{
		if (ZoomFactorNew < 0.0 || ZoomFactorNew > 1.0)
			ZoomFactor = 1.0; // default
		else
			ZoomFactor = ZoomFactorNew;
	}

	public void StateFromFileString(String FileString)
	{
		try
		{
			String[] FileStringElements = FileString.split(FileStringSeparator);

			if (FileStringElements.length != 5)
			{
				SetSuccessOrError(false);
				SetErrorMessage("FileString format error");
				SetIOProgramString("");
				SetZoomFactor(1.0);
				return;
			}

			int FileStringVersionRead = Integer.parseInt(FileStringElements[0]);

			if (FileStringVersionRead != FileStringVersion)
			{
				SetSuccessOrError(false);
				SetErrorMessage("FileString version mismatch");
				SetIOProgramString("");
				SetZoomFactor(1.0);
				return;
			}

			SetSuccessOrError(Boolean.parseBoolean(FileStringElements[1]));
			SetErrorMessage(FileStringElements[2]);
			SetIOProgramString(FileStringElements[3]);
			SetZoomFactor(Double.parseDouble(FileStringElements[4]));
		}
		catch (Exception e)
		{
			SetSuccessOrError(false);
			SetErrorMessage("general FileString parse error");
			SetIOProgramString("");
			SetZoomFactor(1.0);
		}
		return;
	}

	public String StateToFileString()
	{
		StringBuilder FileString = new StringBuilder(IOProgramString.length() + 100); // add some extra space for separators, to avoid unnecessary StringBuilder resizing

		FileString.append(((Integer) FileStringVersion).toString());
		FileString.append(FileStringSeparator);

		FileString.append(((Boolean) SuccessOrError).toString());
		FileString.append(FileStringSeparator);

		FileString.append(ErrorMessage);
		FileString.append(FileStringSeparator);

		FileString.append(IOProgramString);
		FileString.append(FileStringSeparator);

		FileString.append(((Double) ZoomFactor).toString());

		return FileString.toString();
	}
}
